(() => {
    'use strict';

    const STORAGE_KEY = 'sb-kmlgekkbhvapegniuapw-auth-token';

    function syncToken() {
        try {
            const raw = localStorage.getItem(STORAGE_KEY);
            if (!raw) return;

            const parsed = JSON.parse(raw);
            const token = parsed?.access_token;
            if (!token) return;

            chrome.storage.local.set({
                sessionToken: token,
                lastSync: Date.now()
            });
        } catch {}
    }

    setTimeout(syncToken, 300);
    setTimeout(syncToken, 1500);
    setTimeout(syncToken, 3000);

    window.addEventListener('storage', e => {
        if (e.key === STORAGE_KEY) {
            setTimeout(syncToken, 300);
        }
    });

})();
