(() => {
    'use strict';

    const TRUSTED_ORIGIN = 'https://intranet.trackinghighend.com';

    function saveSession(session) {
        if (!session || !session.access_token) {
            console.warn('[Popup] Sessão inválida recebida');
            return;
        }

        chrome.storage.local.set({
            sessionToken: session.access_token,
            refreshToken: session.refresh_token || null,
            user: session.user || null,
            loggedAt: Date.now()
        }, () => {
            if (chrome.runtime.lastError) {
                console.error('[Popup] Erro ao salvar sessão', chrome.runtime.lastError);
            } else {
                console.log('[Popup] ✅ Sessão Supabase salva no chrome.storage.local');
            }
        });
    }

    window.addEventListener('message', (event) => {
        // segurança básica de origem
        if (event.origin !== TRUSTED_ORIGIN) return;

        const data = event.data;

        if (data?.type === 'SUPABASE_SESSION' && data.session) {
            console.log('[Popup] 🔐 Sessão recebida via postMessage');
            saveSession(data.session);
        }
    });
})();
