// Content script que injeta toasts em todas as páginas

(function() {
    'use strict';

    let toastContainer = null;

    // Criar container de toasts
    function createToastContainer() {
        if (toastContainer) return toastContainer;

        toastContainer = document.createElement('div');
        toastContainer.id = 'tracking_toast_container_9b2d4e6f8a1c3e5d';
        document.body.appendChild(toastContainer);

        return toastContainer;
    }

    // Criar toast
    function createToast(notification) {
        const container = createToastContainer();

        const toast = document.createElement('div');
        toast.className = `tracking_toast_item_7c3f9e2a6d4b8e1f tracking_toast_type_${notification.type}_${getTypeHash(notification.type)}`;

        const icon = document.createElement('div');
        icon.className = 'tracking_toast_icon_6d3e9f2a8c4b7e1a';
        icon.textContent = notification.icon;

        const content = document.createElement('div');
        content.className = 'tracking_toast_content_9e2f4a7c6d3b8e1a';

        const title = document.createElement('div');
        title.className = 'tracking_toast_title_4c7e9f2a8d3b6e1a';
        title.textContent = notification.title;

        const message = document.createElement('div');
        message.className = 'tracking_toast_message_7e2f9a4c6d3b8e1a';
        message.textContent = notification.message;

        const closeBtn = document.createElement('button');
        closeBtn.className = 'tracking_toast_close_3f9e2a7c6d4b8e1a';
        closeBtn.textContent = '×';
        closeBtn.onclick = () => removeToast(toast);

        content.appendChild(title);
        if (notification.message) {
            content.appendChild(message);
        }

        toast.appendChild(icon);
        toast.appendChild(content);
        toast.appendChild(closeBtn);

        container.appendChild(toast);

        // Auto remover após 7 segundos
        setTimeout(() => removeToast(toast), 7000);
    }

    function removeToast(toast) {
        toast.classList.add('tracking_toast_removing_2a9f4e7c6d3b8e1a');
        setTimeout(() => {
            if (toast.parentNode) {
                toast.parentNode.removeChild(toast);
            }
        }, 300);
    }

    function getTypeHash(type) {
        const hashes = {
            'notification': '5f8e3a7c2d9b4e6a',
            'event': '3d6f9e2a8c4b7e1f',
            'launch': '8a4c2e9f7b3d6e1a',
            'update': '2e9f4a7c6d3b8e1f'
        };
        return hashes[type] || '5f8e3a7c2d9b4e6a';
    }

    // Listener de mensagens do background
    chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
        if (request.action === 'showToast') {
            createToast(request.notification);
            sendResponse({ success: true });
        }
    });

    console.log('[Tracking Toast Injector] Pronto em:', window.location.hostname);
})();